﻿/*!	\file usartcmd.h
*/ 


#ifndef USARTCMD_H_
#define USARTCMD_H_


/*!	\brief Holds a Table containing all valid Commands
	and the corresponding Address of the routine
	handling it.

	The command string is converted to lower case so
	case does not matter.
*/
typedef struct {
	/*!	\brief	The command string
	
	The string is only evaluated to the length given so you
	can abbreviate commands. Be sure to use unique abbreviations, though.
	*/
	char	*cmd;
	/*!	\brief	The address of the program
	*/
	int8_t	(*adr)(void);
	/*!	\brief	A short explanation printed with the help command.
	
	If helptext is NULL it will not be listed in the help-command.
	This helps to implement 'secret' commands that the normal user
	does not need.
	*/
	const char	*helptext;
} commandTable_t;



uint8_t	ExecCommand(char *str);



#endif /* USARTCMD_H_ */