﻿/*
 * lcd.h
 *
 * Created: 21.11.2012 15:46:04
 *  Author: rolo
 */ 


#ifndef LCD_H_
#define LCD_H_

#include <stdio.h>
#include <stdbool.h>

#define LCD_MAX_WIDTH	20	///< Maximum allowable with of all possible displays
#define LCD_MAX_LINES	4	///< Maximum allowable numbers of lines for all possible displays

extern uint8_t	lcdVbarChar[LCD_MAX_LINES];
extern void LCDInitCGRAM();
extern void	InitLCD(void);
extern void	LCDClear(void);
extern void	LCDGoTo(uint8_t pos);
extern void	LCDPrintLine_P(uint8_t line, const char *fmt, ...);
extern int8_t	LCDHBarGraph(uint8_t line,uint8_t val);
extern bool	LCDBuildVBarChars(uint8_t nBars);
extern uint8_t	lcdVbarChar[LCD_MAX_LINES];

extern FILE lcd;

/*!	\brief	Sets the Brightness of the LCD Backlight
	\note	This is a temporary value and is not stored in the configuration memory.
	\param	val The Brightness
*/
static inline void	LCDSetBrightness(uint8_t val)
{
	OCR1AL=val;
}

/*!	\brief	Gets the current Brightness of the LCD Backlight
	\return	The Brightness
*/
static inline uint8_t	LCDGetBrightness(void)
{
	return OCR1AL;
}

/*!	\brief	Sets the Contrast of the LCD
	\note	This is a temporary value and is not stored in the configuration memory.
	\param	val The Contrast
*/
static inline void	LCDSetContrast(uint8_t val)
{
	OCR1BL=val;
}

/*!	\brief	Gets the current Contrast of the LCD
	\return	The Contrast
*/
static inline uint8_t	LCDGetContrast(void)
{
	return OCR1BL;
}


bool LCDBuildVBarChar(uint8_t nBars);

#endif /* LCD_H_ */