/*!	\file	delay.h
	\note The routines here are hard-timed and only depend
		on the CPU clock. They don't rely on interrupts being
		enabled or timers running but the delay time can be extended if interrupts
		consume CPU time while they are active since interrupts are
		not disabled.<br>
		They just eat up the CPU power for the time they are running.<br>
		If the CPU clock changes you'll have to adopt the delay50us-function since
		all of them rely on this.
 */ 


#ifndef DELAY_H_
#define DELAY_H_


extern void delay50us(void);	///< Delays for 50us. This routine is hard-timed and does not rely on interrupts
extern void delay5ms(void);		///< Delays for 5ms. This routine is hard-timed and does not rely on interrupts
extern void delay50ms(void);	///< Delays for 50ms. This routine is hard-timed and does not rely on interrupts
extern void	delay1s(void);		///< Delays for one second. This routine is hard-timed and does not rely on interrupts




#endif /* DELAY_H_ */