/*! \file adeunis.h

	\brief	Definitions for the Adeunis Bluetooth Module
	
	\note	This file does not include all opcodes for the LMX9830
		but only those we currently need.
	
	\copyright Copyright (C) 2013  Robert Loos	<http://www.loosweb.de>
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.<br>
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.<br>
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef ADEUNIS_H_
#define ADEUNIS_H_

#include <stdbool.h>

#define ADEUNIS_REQ						0x52	///< Request telegram
#define ADEUNIS_CFM						0x43	///< Confirm telegram
#define ADEUNIS_IND						0x69	///< Indication telegram
#define ADEUNIS_RES						0x72	///< Response telegram

#define	LMX9830_READY					0x25
#define	SPP_INCOMING_LINK_ESTABLISHED	0x0c
#define	SPP_LINK_RELEASED				0x0e
#define	SPP_TRANSPARENT_MODE			0x11

/*!	\brief	Description of a Bluetooth Packet

	\note	This struct does not include the starting STX and terminal ETX of
	the frame transmitted over the serial line.
*/
typedef struct
{
	uint8_t	packetType;
	uint8_t	opcode;
	uint8_t	dataLengthL;	///< The low byte of the data length
	/*!	\brief	The high byte of the data length
	
	\note	We currently ignore the high byte of the length since we
	don't have enough memory to store packets bigger then cmdline.
	Packets that big don't appear until now.<br>
	Be aware that this is some kind of security risk.
	If a paired sender manages to send arbitrary large packets he
	could send requests to the display.
	Since this is only possible while the Bluetooth module is
	not in transparent mode, this seems acceptable to me.
	*/
	uint8_t	dataLengthH;
	uint8_t	checksum;		///< The checksum from packetType to dataLengthH
	uint8_t	data[];			///< The data
} BTPacket_t;

/*!	\brief	Collects Status Information about Bluetooth in a single Unity
*/
typedef struct
{
	bool	haveBT;	///< Do we have a Bluetooth module at all?
	bool	linkEstablished;	///< Bluetooth link established
	uint8_t	remoteAddress[6];	///< Bluetooth address of the host
	uint8_t	localPort;	///< Number of the local port
	uint8_t	unknTelCnt;	///< Number of unknown telegrams detected
} BTStatus_t;

extern BTStatus_t	BTStatus;

#endif /* ADEUNIS_H_ */