// uart.h

#include <stdio.h>
#include "Config.h"

#define USE_RTS	// comment this out if your circuit does not have RTS/CTS-lines
#define UART0_DE_MASK	0x04
#define UART0_PORT	PORTE
#define UART1_DE_MASK	0x02
#define UART1_RTS_MASK	0x10
#define UART1_CTS_MASK	0x20
#define UART1_PORT	PORTD
#define UART1_PIN	PIND

#define SENSOR_BAUD	9600
#define HOST_BAUD	9600
#define SENSOR_UBRR	(F_CPU/16/SENSOR_BAUD-1)
#define HOST_UBRR	(F_CPU/16/HOST_BAUD-1)

// Buffer Sizes. Must be <255 since the Pointers are only uint8_t
#define UART0_BUFSIZE	40	///< Size of the UART0 Buffers
#define UART1_BUFSIZE	200	///< UART1 really communicates, so a little more

extern uint8_t charsInRbuf0;
extern uint8_t computedChecksum;
extern volatile char cksum0;
extern volatile char rbuf0[];
extern volatile uint8_t	tbuf1_tail,tbuf1_head;
extern volatile uint8_t	byteFromHost;
extern volatile uint8_t	hostCommandsLost;

extern FILE	uart0,uart1;
extern void InitUart(void);
extern void putc0(char);
extern void putd0(char);
extern int putchar_uart1(char,FILE*);
extern int hprintf_P(const char *fmt, ... );
extern void usart1FlushRx(void);
extern bool	Tbub1IsEmpty(void);


/*!	\brief	Enables the RS485 Line Driver on Uart0
*/
static inline void Uart0EnableLineDriver(void)
{
	UART0_PORT|=UART0_DE_MASK;
}

/*!	\brief	Disables the RS485 Line Driver on Uart0
*/
static inline void Uart0DisableLineDriver(void)
{
	UART0_PORT&=~UART0_DE_MASK;
}

/*!	\brief	Enables the RS485 Line Driver on Uart1
*/
static inline void Uart1EnableLineDriver(void)
{
	UART1_PORT|=UART1_DE_MASK;
}

/*!	\brief	Disables the RS485 Line Driver on Uart1
*/
static inline void Uart1DisableLineDriver(void)
{
	UART1_PORT&=~UART1_DE_MASK;
}

/*!	\brief	Timer Callback. Checks for CTS from the Host to resume Communication.

	This function re-enables interrupts after CTS becomes true again and must be called
	periodically e.g. from timer interrupt.
*/
static inline void	UsartTimerCallback(void)
{
#ifdef USE_RTS
	if (config.useRts)
	{
		if (!(UART1_PIN & UART1_CTS_MASK) && (tbuf1_head!=tbuf1_tail))
		{
			UCSR1B|=0b01100000;			// enable UDRE and TX Complete interrupt
		}
	}
#endif
}

/*!	\brief	Asserts RTS to the Host Line, i.e. allows the Host to send Data
*/
static inline void	AssertRTS(void)
{
#ifdef	USE_RTS	// Defined out...
	if (config.useRts)	// Config'd out...
		UART1_PORT&= ~UART1_RTS_MASK;
#endif
}

/*!	\brief	Releases RTS to the Host Line, i.e. stops the Host from sending Data
*/
static inline void	ReleaseRTS(void)
{
#ifdef USE_RTS
	if (config.useRts)
		UART1_PORT|=UART1_RTS_MASK;
#endif
}