﻿/*
 * sound.h
 *
 * Created: 25.08.2011 09:53:05
 *  Author: rolo
 */ 


#ifndef SOUND_H_
#define SOUND_H_

extern uint8_t	sndToneCnt;
extern uint8_t	sndSeqPlaying;

extern uint8_t	sndErrorSeq[];
extern uint8_t	sndSuccessSeq[];
extern uint8_t	sndBigBenSeq[];
extern uint8_t	sndSig1[];
extern uint8_t	sndSig2[];

extern uint8_t	*musicPtr;

void	SndToneOn(uint16_t tone);
void	SndToneOff(void);
void	PlayTone(uint16_t tone,uint8_t duration);
void	PlayNote(uint8_t note,uint8_t duration);
void	PlaySequence(uint8_t *seq);

/*! \brief Initializes sound hardware and state
*/
static inline void	InitSound()
{
	sndToneCnt=0;
	sndSeqPlaying=0;
	musicPtr=0;	// no sequence currently playing
	
	TCCR3A=0b01000011;	// Toggle OC3A on compare match
	TCCR3B=0b00011000;	// Fast PWM, clock off
}


/*! \brief Must be called by system timer (10ms)
*/
static inline void	SndTimerCallback()
{
	if (sndToneCnt>0)
	{
		sndToneCnt--;
		if (sndToneCnt==0)
		{
			if (musicPtr!=0)	// Another note to play
			{
				if (*(musicPtr+1)==0)	// duration 0?
				{
					musicPtr=0;	// end of sequence
					SndToneOff();
				}
				else
				{
					PlayNote(*musicPtr,*(musicPtr+1));
					musicPtr+=2;
				}
			} else
			{
				SndToneOff();
			}
		}
	}
}



#endif /* SOUND_H_ */