﻿/*! \file led.h

	\brief	Provides inline Functions for controlling the LEDs
	
	\copyright Copyright (C) 2013  Robert Loos	<http://www.loosweb.de>
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.<br>
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.<br>
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 	Current LED usage:<br><table>
	<tr><td>RED</td><td>On during ADC Interrupt</td></tr>
	<tr><td>YELLOW</td><td>On during timer0 interrupt</td></tr>
	<tr><td>GREEN</td><td>On during Sleep in the main loop. A bright green LED means we have reserves in computing time!</td></tr>
	<tr><td>BLUE</td><td>Mirror of the DCF77 receive signal. Helpfull for placing and orienting the receiver.</td></tr>
	</table>
*/

#ifndef LED_H_
#define LED_H_

#define LEDPORT			PORTA
#define LEDREDMASK		0b00010000
#define LEDYELLOWMASK	0b00100000
#define LEDGREENMASK	0b01000000
#define LEDBLUEMASK		0b10000000

/*!	\brief	Switches the red LED on */
static inline void LEDRedOn(void)
{
	LEDPORT &= ~LEDREDMASK;
}

/*!	\brief	Switches the red LED off */
static inline void LEDRedOff(void)
{
	LEDPORT |= LEDREDMASK;
}

/*!	\brief	Switches the yellow LED on */
static inline void LEDYellowOn(void)
{
	LEDPORT &= ~LEDYELLOWMASK;
}

/*!	\brief	Switches the yellow LED off */
static inline void LEDYellowOff(void)
{
	LEDPORT |= LEDYELLOWMASK;
}

/*!	\brief	Switches the green LED on */
static inline void LEDGreenOn(void)
{
	LEDPORT &= ~LEDGREENMASK;
}

/*!	\brief	Switches the green LED off */
static inline void LEDGreenOff(void)
{
	LEDPORT |= LEDGREENMASK;
}

/*!	\brief	Switches the blue LED on */
static inline void LEDBlueOn(void)
{
	LEDPORT &= ~LEDBLUEMASK;
}

/*!	\brief	Switches the blue LED off */
static inline void LEDBlueOff(void)
{
	LEDPORT |= LEDBLUEMASK;
}



#endif /* LED_H_ */