/*
 * ftest.h
 *
 * Created: 19.02.2013 17:17:27
 *  Author: Robert
 */ 


#ifndef FTEST_H_
#define FTEST_H_

#include <stdbool.h>

/*!	\brief	Holds the test declarations for one Port.

	You have to set up an array of this struct containing ALL
	ports in ascending order (even if the port is not tested at all)
	since the index will be interpreted as PORTA, B, C and so on
*/
typedef struct  
{
	volatile uint8_t	*port;	///< Address of the PORTx-register
	volatile uint8_t	*pin;	///< Address of the PINx-register
	uint8_t	testMask;	///< Bit mask of which pins to test. All 1-bits are tested.
} ftestPortsStruct;

extern bool	FTest(void);
extern void FTest485(void);


#endif /* FTEST_H_ */