﻿/*
 * dcf77.h
 *
 * Created: 15.10.2012 15:30:24
 *  Author: rolo
 */ 

#ifndef DCF77_H_
#define DCF77_H_

#include <stdbool.h>
#include <stdint.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include "Config.h"
#include "led.h"

#define DCF77_PIN	PINA
#define DCF77_PORT	PORTA
#define DCF77_DDR	DDRA
#define DCF77_PINMASK	(1<<1)

extern bool	DCFInSync;

extern void	DCF77int(void);
extern int32_t	GetDCFdiff();
extern void Invalidate();
extern uint8_t	min,hour;
extern int32_t	DCFdiff;

/*!	\brief Initializes the DCF77-Variables

	Must be called during system initialization
*/
static inline void	InitDCF77(void)
{
	DCF77_DDR &= ~DCF77_PINMASK;	// DCF77-pin is input
	DCF77_PORT |= DCF77_PINMASK;	// Enable pull up
	Invalidate();
}

/*!	\brief	Synchronizes the RTC with DCF77
*/
static inline void	RTCsync(void)
{
	static int32_t	lastDiff=0;	// Keeps Track of Time Difference for hard Sync
	
	if (min==0)
	{
		return;	// It saves us trouble not syncing at an hour border
	}
	DCFdiff=hour*3600l+min*60l-hrCnt*3600l-minCnt*60l-secCnt;
	if (DCFdiff<-43200)
	{
		DCFdiff+=86400l;
	}
	if (DCFdiff>=43200)
	{
		DCFdiff-=86400l;
	}
	if (DCFdiff>60 || DCFdiff<-60)	// more than a minute, step time
	{
		if (abs(DCFdiff-lastDiff)<=1)	// nearly same difference received twice, step!
		{
			if (dFlags&DFLAG_DCF77)
			{
				hprintf_P(PSTR("Step time "),DCFdiff,RTCAdj);
			}
			hrCnt=hour;
			minCnt=min;
			secCnt=0;
			DCFdiff=0;
			RTCAdj=RTC_NORMAL;
		}
		else
		{
			lastDiff=DCFdiff;
		}
	} else if (DCFdiff>0)
	{
		RTCAdj=RTC_FASTER;
	} else if (DCFdiff<0)
	{
		RTCAdj=RTC_SLOWER;
	} else
	{
		RTCAdj=RTC_NORMAL;
	}
	if (dFlags&DFLAG_DCF77)
	{
		hprintf_P(PSTR("Diff:%ld Tick: %d Adj:%s\n"),DCFdiff,tickCnt,RTCAdjTxt[RTCAdj]);
	}
	DCFInSync=true;
}



#endif /* DCF77_H_ */