﻿/*
 * adc.h
 *
 * Created: 13.11.2012 14:05:16
 *  Author: rolo
 */ 

#include <avr/interrupt.h>

#ifndef ADC_H_
#define ADC_H_

extern volatile uint8_t	adcFlags;
static const uint8_t	ADCFLAG_NEWRESULTS=1;	///< All Channels have been updated
static const uint8_t	ADCFLAG_NEWAVERAGES=2;	///< All Averages have been updated
volatile uint16_t	channelMismatchCnt;

/*!	\brief Holds raw ADC Values for all Channels
*/
typedef union
{
	struct
	{
		uint16_t	ADC_Temp;	///< Display Temperature
		uint16_t	ADC_P5;		///< 5V Supply
		uint16_t	ADC_Unreg;	///< Unregulated Supply
		uint16_t	ADC_SWUnreg;	///< Switched Unreg to the Sensor
		uint16_t	ADC_P3;		///< 3.3V Supply
	} named;	///< Named Values per Channel
	uint16_t	array[5];	///< Array for access via Channel Number
} ADCData_t;


extern volatile ADCData_t	ADCData;
extern volatile ADCData_t	ADCDataAvg;
extern volatile ADCData_t	ADCDataMin;
extern volatile ADCData_t	ADCDataMax;
extern volatile ADCData_t	ADCDataMinTmp;
extern volatile ADCData_t	ADCDataMaxTmp;


static inline void ADCcli(void)
{
	ADCSRA &= ~(1<<ADIE);
}

static inline void ADCsei(void)
{
	ADCSRA = (ADCSRA | 1<<ADIE) & ~(1<<ADIF);	// Set ADIE without resetting ADIF!
}

void	InitADC(void);

/*!	\brief	Resets the Min/Max values of the Analog Values
*/
static inline void	ADCResetMinMax(void)
{
	ADCcli();
	for (int i=4;i>=0;i--)
	{
		ADCDataMin.array[i]=ADCDataMinTmp.array[i];
		ADCDataMax.array[i]=ADCDataMaxTmp.array[i];
		ADCDataMinTmp.array[i]=0xffff;
		ADCDataMaxTmp.array[i]=0;
	}
	ADCsei();
}

#endif /* ADC_H_ */