// Lumberg NEB 21 R Barrel Jack
// Author: Robert Loos
// All dimensions in mm

module base() {
    color([0.1,0.1,0.1]) difference() {
        union() {
            translate([-13.5,-4.5,0]) cube([13.8,9,6.5]);
            translate([-13.5,-4.5,0]) cube([3,9,11]);
            translate([-13.5,0,6.5]) rotate([0,90,0]) cylinder(d=8,$fn=18,h=13.8);
        }
        union() {
            translate([-13.51,0,6.5]) rotate([0,90,0]) cylinder(d=6,$fn=18,h=11);
            translate([-12.5,-3,1]) cube([10,6,5.5]);
        }
        // engrave a text so people know what this is
        translate([-11,-4.3,4]) rotate([90,0,0]) linear_extrude(1) text("Lumberg", size=1.5);
        translate([-11,-4.3,2]) rotate([90,0,0]) linear_extrude(1) text("NEB 21 R", size=1.5);
    }
    // the pin
    color([0.7,0.7,0.7]) translate([-12.3,0,6.5]) rotate([0,90,0]) union() {
        cylinder(d=1.95,$fn=18,h=9.7);
        sphere(d=1.95,$fn=18);
    }
    // a symbolic contact spring for a better look
    color([0.7,0.7,0.7]) translate([-8,-2.5,5]) rotate([0,140,0])
    cube([5,5,0.3]);
}

module pin(x,y,w,rot) {
    color([0.7,0.7,0.7]) translate([x,y,-.1]) rotate([0,0,rot]) translate([-.15,-w/2,-3.5+w/2]) union() {
        cube([.3,w,3.5-w/2]);
        translate([0,w/2,0]) rotate([0,90,0]) cylinder(d=w,$fn=18,h=.3);
    }
}


translate([0,0,0]) base();
pin(-2.75,-4.7,2.5,90);
pin(-6,0,2.5,0);
pin(0,0,3.5,0);
