/*
 * scale.h
 *
 * Created: 01.12.2017 11:50:46
 *  Author: Robert Loos
 */ 


#ifndef SCALE_H_
#define SCALE_H_
#include <stdbool.h>

#define USE_GetAvg2	///< Selection of averaging algorithm. Set to USE_GetAvg1 or USE_GetAvg2 as desired.

#if defined(__DOXYGEN__) || defined(USE_GetAvg1)
#define MAXHIST	64			///< Memory reserved for moving average, used for precision measurement mode
#define MINHIST	8			///< Number of values used for fast measurement mode
extern uint8_t histSize;	///< Number of values used for moving average
#endif
#if defined(__DOXYGEN__) || defined(USE_GetAvg2)
#define MIN_AVG_WEIGHT	4	///< Multiplier for average Value in GetAvg2
#define MAX_AVG_WEIGHT	10	///< Multiplier for average Value in GetAvg2. Maximum value is 21
extern uint8_t	avgFactor;	///< The factor, the last weight is stronger than the current measurement value
#endif
#if defined(__DOXYGEN__) || defined(USE_GetAvg3)
#define NUM_COEFF 11	// number of filter coefficients
extern const int8_t coeff[];	///< The Array holding the Filter Coefficients
extern int32_t	weightHist[];	///< Array holding the last Weight Values
#endif

typedef	uint16_t	delay_t;	///< The data type used by DelayMs(). Set to a type capable of counting the max ms you want to use.
typedef int32_t weight_t;	///< The data type for a weight value

extern weight_t	sum128;
extern uint8_t	cnt128;

extern volatile uint8_t	tickCnt,secCnt;
extern volatile uint8_t	zeroWeightSecCnt;

extern uint8_t	hxCnt;
extern bool HXdisplayWeight;

/*! \defgroup Flags Flags

	Flags indicating timer events and errors. They are set when the error condition appears.
	@{*/
extern volatile uint8_t	tFlags;
extern volatile uint8_t	eFlags;
static const uint8_t TFLAG_SEC=1;	///< Is set once per Second
static const uint8_t EFLAG_UNCAL=1;	///< Device has not been calibrated
static const uint8_t EFLAG_LOBAT=2;	///< Is set on low Supply Voltage
/*! @} */

/*! \defgroup Switch_Actions Switch Actions

	This typedef declares the possible switch actions.
	We have only one pushbutton switch so we can distinct
	between short presses (less than two seconds), medium presses
	(between 2 and 10 seconds) and really long presses of
	more than 10s, which is used to enter calibration mode.
	@{*/
typedef enum
	{	SWITCH_NONE,	///< Switch is not pressed
		SWITCH_SHORT,	///< Switch has been pressed for less than 2 Seconds
		SWITCH_MED,		///< Switch has been pressed for more than 2 Seconds
		SWITCH_LONG,	///< Switch has been pressed for more than 10 Seconds
		SWITCH_DOUBLE,	///< Doubleclick; switch has been pressed short two times within 500ms
	} SWITCH_ACTION_t;
extern volatile SWITCH_ACTION_t	switchAction;
/*! @} */

static inline void	PowerOff(void)
{
	for (;;)
	{
		PORTD &= ~0b00100000;	// switch power off
	}
}

static inline void	PowerOn(void)
{
	PORTD |= 0b00100000;	// hold power on
}

extern void	DelayMs(delay_t ms);
extern void	Calibrate(void);

#endif /* SCALE_H_ */