/*
 * display.h
 *
 * Created: 01.12.2017 12:52:47
 *  Author: Robert Loos
 */ 


#ifndef DISPLAY_H_
#define DISPLAY_H_


extern void	NextDigit(void);
extern void	Int8toDisplayHex(uint8_t b, volatile uint8_t *p);
extern void	Int16toDisplayHex(uint16_t i,volatile uint8_t *p);
extern void	Int24toDisplayHex(uint32_t l, volatile uint8_t *p);

/*! \defgroup Display_Mode Display Mode

	If set to DISPLAY_NORMAL, it will stay there and only
	display[] is displayed permanently.<br>
	If set to DISPLAY_ALT_SHOW_NORMAL, the timer interrupt will alter it
	to DISPLAY_ALT_SHOW_ALT and back in regular intervals to display
	display[] and display_alt[] alternatingly.<br>
	Do not set displayMode directly but use the (inline) functions
	DisplayNormal() and DisplayAlt().
	@{*/
typedef enum {
	DISPLAY_NORMAL,	///< display[] is displayed permanently
	DISPLAY_ALT_SHOW_NORMAL,	///< display[] and display_alt[] is displayed in a 4 second period
	DISPLAY_ALT_SHOW_ALT	///< display[] and display_alt[] is displayed in a 4 second period
	} DISPLAY_MODE_t;
extern	volatile DISPLAY_MODE_t	displayMode;
/*! @} */

/*!	\defgroup Display_Blink Display Blinking

	The normal display can be set to blink at two
	different rates while the alternate display,
	which is shown for only one second, is turned off
	for 300ms in the middle of the second.
	@{*/
extern volatile uint8_t	displayBlinkMask;

#define BLINK_SLOW	1	///< The normal display blinks slowly (0.5hz)
#define BLINK_FAST	2	///< The normal display blinks fast (1hz)
#define BLINK_ALT	4	///< The alternate display blinks
/*! @} */

extern	volatile uint8_t	displayBrightness;
extern	volatile	uint8_t	display[7], display_alt[7];
extern	const uint8_t chars[];
void SetDisplayCLR(volatile uint8_t *adr);
void SetDisplayCAL(void);
void SetDisplayRESET(volatile uint8_t *adr);
void SetDisplayAuto0(volatile uint8_t *adr);
void SetDisplayDontTouch(void);
void SetDisplayRef(void);
void SetDisplayAltLoBat(void);
void SetDisplayAltUncal(void);
void SetDisplayDefCon(void);
void SetDisplayHiRes(void);
void SetDisplayLoRes(void);

/*!	\brief Sets the Display to normal Mode

	Only display[] is displayed then.
*/
static inline void	DisplayNormal(void)
{
	displayMode=DISPLAY_NORMAL;
}

/*! \brief Sets the Display to alternate Mode

	display[] is displayed for three seconds, then
	display_alt[] is displayed for one second.
	display_alt[] normally contains some error message
	(like "Low Bat" etc).
*/
static inline void	DisplayAlt(void)
{
	if (displayMode==DISPLAY_NORMAL)
	{
		displayMode=DISPLAY_ALT_SHOW_NORMAL;
	}
}

// Non-hex characters
static const uint8_t	DISPLAY_L=0x10;
static const uint8_t	DISPLAY_n=0x11;
static const uint8_t	DISPLAY_r=0x12;
static const uint8_t	DISPLAY_t=0x13;
static const uint8_t	DISPLAY_MINUS=0x14;
static const uint8_t	DISPLAY_DEGREE=0x15;
static const uint8_t	DISPLAY_SPACE=0x16;
static const uint8_t	DISPLAY_u=0x17;
static const uint8_t	DISPLAY_o=0x18;
static const uint8_t	DISPLAY_c=0x19;
static const uint8_t	DISPLAY_h=0x1a;
static const uint8_t	DISPLAY_APOSTROPHE=0x1b;
static const uint8_t	DISPLAY_H=0x1c;

#endif /* DISPLAY_H_ */