﻿/*! \file config.h

	\brief	Structures and Constants for Configuration Handling
	
	\copyright Copyright (C) 2013  Robert Loos	<http://www.loosweb.de>
	
	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.<br>
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.<br>
	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef CONFIG_H_
#define CONFIG_H_

#include <stdbool.h>
#include <stdio.h>
#include "scale.h"

#define CONF_MAGIC	0x0101	///< Increment this value if confStruct_t becomes incompatible to previous versions!


/*!	\brief Holds all Configuration Data stored in EEPROM
*/
typedef struct
{	uint16_t		magic;	//!< Used to discover unprogrammed Devices
	int32_t			cal_num;	///< The numerator of the Calibration Fraction
	int32_t			cal_denom;	///< The Denominator of the Calibration Fraction
	bool			isCalibrated;	///< True if calibration has been performed, false on new Devices or after DefaultConfig()
} confStruct_t;

extern confStruct_t	config;
extern void	ReadConfig(void);
extern void	WriteConfig(void);

#endif /* CONFIG_H_ */