
/*
 * bin2bcd.s
 *
 * Created: 01.12.2017 15:46:39
 *  Author: Robert Loos
 *
 * This file is Freeware.
 * Feel free to use for any purpose.
 */ 

.global Bin6toBCD8
.global Bin4toBCD5

; ******************************************************************************
; * Called from C with a long as argument containing a 24 bit binary value     *
; * Returning a long containung the packed BCD value                           *
; * Used registers R18..R25                                                    *
; * R22..R25 are the packed BCD result, R18..R20 hold the 24 bit binary value  *
; * In AVR-GCC these registers are free (call-used)                            *
; ******************************************************************************

	.text
Bin6toBCD8:
	MOV	R20,R24
	MOV R19,R23
	MOV R18,R22
	LDI R21,24		; counter 24 bit shifts
	; clear result
	CLR	R22
	CLR R23
	CLR R24
	CLR R25
shiftloop:
	; check every digit >5 and add 3
	SUBI R22,-0x33
	SBRS R22,3
	SUBI R22,3
	SBRS R22,7
	SUBI R22,0x30

	SUBI R23,-0x33
	SBRS R23,3
	SUBI R23,3
	SBRS R23,7
	SUBI R23,0x30

	SUBI R24,-0x33
	SBRS R24,3
	SUBI R24,3
	SBRS R24,7
	SUBI R24,0x30

	SUBI R25,-0x33
	SBRS R25,3
	SUBI R25,3
	SBRS R25,7
	SUBI R25,0x30
	; shift through the data
	CLC
	ROL R18
	ROL R19
	ROL R20
	ROL R22
	ROL R23
	ROL R24
	ROL R25

	DEC R21			; counts down from 24
	BRNE shiftloop
	RET



	Bin4toBCD5:
	MOV R19,R25
	MOV R18,R24
	LDI R21,16		; counter 16 bit shifts
	; clear result
	CLR	R22
	CLR R23
	CLR R24
	CLR R25
shiftloop2:
	; check every digit >5 and add 3
	SUBI R22,-0x33
	SBRS R22,3
	SUBI R22,3
	SBRS R22,7
	SUBI R22,0x30

	SUBI R23,-0x33
	SBRS R23,3
	SUBI R23,3
	SBRS R23,7
	SUBI R23,0x30

	SUBI R24,-0x33
	SBRS R24,3
	SUBI R24,3
	SBRS R24,7
	SUBI R24,0x30

	; shift through the data
	CLC
	ROL R18
	ROL R19
	ROL R22
	ROL R23
	ROL R24

	DEC R21			; counts down from 24
	BRNE shiftloop2
	RET