// IPAK Transistor
// Author: Robert Loos
// All dimensions in mm

module base() {
    color([0.1,0.1,0.1]) translate([0,1,1.01]) difference() {
        translate([-6.35/2,.58/2,0]) rotate([90,0,0]) cube([6.35,6.73,2.38]);
        // engrave a text so people know what this is
        translate([0,-2,3]) rotate([90,0,0]) linear_extrude(1) text("IPAK", size=1.5,halign="center");
    }
}

module pin(x,y) {
    color([0.7,0.7,0.7]) translate([x-1.14/2,y-.58/2,-3]) union() {
        cube([1.14,.58,4]);
        translate([(1.14-1.6)/2,0,3]) cube([1.6,.58,1]);
    }
}

module tab() {
    color([0.7,0.7,0.7]) translate([-5.45/2,1.3,6.35+1.4-3.93]) rotate([90,0,0]) linear_extrude(.58) polygon(points=[[0,0],[5.45,0],[5.45,3.93+1.27-.635],[5.45-.635,3.93+1.27],[.635,3.93+1.27],[0,3.93+1.27-.635]]);
}

translate([2.29,0,0]) {
    base();
    pin(-2.29,0);
    pin(2.29,0);
    pin(0,0);
    tab();
}
