// uart.h


#ifndef UART_H_
#define UART_H_

//#define USE_RTS	// comment this out if your circuit does not have RTS/CTS-lines
#include <stdio.h>
#include "Config.h"

/* We don't have RTS/CTS and Driver Enable
#define UART0_DE_MASK	0x04
#define UART0_PORT	PORTE
#define UART0_PIN	PINE*/

#define HOST_BAUD	115200
#define HOST_UBRR	(F_CPU/16/HOST_BAUD-1)

// Buffer Sizes. Must be <255 since the Poiters are only uint8_t
#define UART0_TXBUFSIZE	10	///< Size of the UART0 transmit buffer
#define CMDLINE_MAX	20	// Maximum Number of characters used in a Command Line
extern volatile char	cmdline[CMDLINE_MAX+1];

extern volatile uint8_t cFlags;
static const uint8_t CFLAG_PARITYERROR=4;	///< Parity Error in received Byte
static const uint8_t CFLAG_CHECKSUMERROR=8;	///< Checksum Error in received Telegram
static const uint8_t CFLAG_CMDRECEIVED=16;	///< Received the terminating CR of a Command
static const uint8_t CFLAG_BYTERECEIVED=32;	///< Received a Byte from the host

extern volatile uint8_t	tbuf0_tail,tbuf0_head;
extern volatile uint8_t	byteFromHost;
extern volatile uint8_t	hostCommandsLost;

extern FILE	uart0;
extern void InitUart(void);
extern int putchar_uart0(char,FILE*);
extern int hprintf_P(const char *fmt, ... ) __attribute__ ((format(printf,1,2)));
extern void Usart0FlushRx(void);


/*!	\brief	Timer Callback. Checks for CTS from the Host to resume Communication.

	This function re-enables interrupts after CTS becomes true again and must be called
	periodically e.g. from timer interrupt.
*/
static inline void	UsartTimerCallback(void)
{
#ifdef USE_RTS
	if (config.useRts)
	{
		if (!(UART0_PIN & UART1_CTS_MASK) && (tbuf0_head!=tbuf0_tail))
		{
			UCSR1B|=0b01100000;			// enable UDRE and TX Complete interrupt
		}
	}
#endif
}

/*!	\brief	Asserts RTS to the Host Line, i.e. allows the Host to send Data
*/
static inline void	AssertRTS(void)
{
#ifdef	USE_RTS	// Defined out...
	if (config.useRts)	// Config'd out...
		UART1_PORT&= ~UART1_RTS_MASK;
#endif
}

/*!	\brief	Releases RTS to the Host Line, i.e. stops the Host from sending Data
*/
static inline void	ReleaseRTS(void)
{
#ifdef USE_RTS
	if (config.useRts)
		UART1_PORT|=UART1_RTS_MASK;
#endif
}
#endif
