﻿/*!	file screen.h
*/ 


#ifndef SCREEN_H_
#define SCREEN_H_

#include "stdint.h"
#include "control.h"

typedef	uint8_t	screenTimeout_t;	///< Use a suitable unsigned type to allow the longest timeout you would need

/*!	\brief Holds the data for a screen item

	This is a control-struct and a return
	value which is passed if the control is activated.
*/
typedef struct
{
	control_t	*control;	///< E.g. the text of a text field or the enterNumber_t of an input field
	uint8_t	retval;	///< If retval !=0 the screen terminates if the user presses enter
} screenItem_t;

/*!	\brief Holds the structure to build up a screen
*/
typedef struct
{
	uint8_t	numberOfItems; ///< Computed by initScreen()
	screenTimeout_t	timeout;	///< If >0, the screen is terminated after &lt;timeout&gt; Seconds
	screenItem_t	*item[];
} screen_t;

typedef enum {micro,milli,one,kilo,mega} prefixType;
/*!	\brief Holds the values for a prefix-value

	The lastPrefix Value is used to implement a threshold
	for switching between prefixes. I would be very disturbing
	and hard to read if the value would switch from 999 to 1.00k
	at short intervals.
*/
typedef struct  
{
	uint8_t	lastPrefix;	///< Prefix used at last update
	char	value[6];	///< The formatted value for printf
} prefixValue_t;
void formatPrefixValue(prefixValue_t *val,double newVal);

/*! \brief Contains the prefixValues for all sinks for display
*/
typedef struct  
{
	prefixValue_t	u;
	prefixValue_t	i;
	prefixValue_t	r;
	prefixValue_t	p;
} sinkPrefixValues_t;

uint8_t	doScreenManualTest(void);
uint8_t	doScreenDischgTest(void);
void	doScreenSystem(void);

uint8_t	Screen(screen_t *screen);
screenItem_t	inSink1_s;

extern screen_t	screenVersion;
extern const char	txtSetPoint_t[];

#endif /* SCREEN_H_ */