﻿/*
 * menu.h
 *
 * Created: 30.08.2011 13:00:40
 *  Author: rolo
 */ 


#ifndef MENU_H_
#define MENU_H_


/*! \brief Contains data for one menu item
	\note 	This struct must reside in PROGMEM!
*/
typedef struct  
{
	char	shortcut;	///< One character abbreviation to select (only digits possible)
	const char *text;	///< The text for the menu line. Must reside in PROGMEM!
	uint8_t	(*action)(void);	///< Address of the corresponding function
} menuItem_t;

/*! \brief Contains one menu

	The menu must be small enough to fit on one screen.
	Scrolling through menus is not implemented.
	If the action of a menu item is 0, the menu
	is terminated ("back"-function).
	The last entry must have a null text-pointer.
	This is used to count the menu entries.
	\note 	This struct must reside in PROGMEM!
*/
typedef struct
{
	const char	*head;
	menuItem_t	entry[];
} menu_t;

void	Menu(const menu_t *menu);

extern const menu_t menuStructMain;
void	MenuMain(void);
extern uint8_t	redrawRequest;

#endif /* MENU_H_ */