/*! \file led.c

	\brief	Routines for handling the LEDs
	
	\copyright Copyright (C) 2009 Robert Loos	<http://www.loosweb.de>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/">.
<p></p>
 */ 

#include "Eload.h"
#include "led.h"

/*!	\brief	Timer Callback Function

	Should be called every 10ms to achieve the desired timing.
*/
void	LedTimerCallback(void)
{
#ifdef LED_USE_TIMER
	static uint8_t	delayCnt;
	static LED_FLASH_t	bitMask;
	uint8_t	tmp;
	
	delayCnt++;
	if (delayCnt>=LED_TIMER_SLOWDOWN)	// Every 200ms
	{
		delayCnt=0;
		if (bitMask==0)
		{
			bitMask=1;
		}
#ifdef LEDRED_USE_TIMER
		if (ledRedData & bitMask)
		{
			LEDRedOn();
		}
		else
		{
			LEDRedOff();
		}
#endif
		tmp=0;
		for (uint8_t i=0;i<8;i++)
		{
			tmp>>=1;
			if (!(ledData.array[i]&bitMask))
			{
				tmp|=128;
			}
		}
		SPISetLEDs(tmp);
		bitMask <<= 1;
	}
#endif
}