﻿/*
 * lcd.h
 *
 * Created: 21.11.2012 15:46:04
 *  Author: rolo
 */ 


#ifndef LCD_H_
#define LCD_H_

#include <avr/io.h>
#include <stdio.h>
#include <stdbool.h>

#define LCD_WIDTH	20	///< Number of characters
#define LCD_LINES	4	///< Number of lines
#define LCD_LINE1	0
#define LCD_LINE2	64
#define LCD_LINE3	20
#define LCD_LINE4	84


extern uint8_t	lcdVbarChar[LCD_LINES];
extern const uint8_t LCDStartLine[];
extern void LCDInitCGRAM();
extern void	LDCInit(void);
extern void	LCDCursorOn(void);
extern void	LCDCursorOff(void);
extern void	LCDClear(void);
extern void	LCDGoTo(uint8_t pos);
extern uint8_t LCDGoToXY(uint8_t x, uint8_t y);
void	LCDWriteData(char c);
extern void	LCDPrintLine_P(uint8_t line, const char *fmt, ...);
void LCDWriteString(const char *s);
void LCDWriteString_P(const char *s);
extern int8_t	LCDHBarGraph(uint8_t line,uint8_t val);
extern bool	LCDBuildVBarChars(uint8_t nBars);
extern uint8_t	lcdVbarChar[LCD_LINES];
extern void	LCDSecondlyCallback(void);
extern void	LCDActivateBacklight(void);

extern FILE lcd;

/*!	\brief	Sets the Brightness of the LCD Backlight
	\note	This is a temporary value and is not stored in the configuration memory.
	\param	val The Brightness
*/
static inline void	LCDSetBrightness(uint8_t val)
{
	OCR2B=val;
}

/*!	\brief	Gets the current Brightness of the LCD Backlight
	\return	The Brightness (0=0%, 255=100%)
*/
static inline uint8_t	LCDGetBrightness(void)
{
	return OCR2B;
}

/*!	\brief	Sets the Contrast of the LCD
	\note	This is a temporary value and is not stored in the configuration memory.
	\param	val The Contrast
*/
static inline void	LCDSetContrast(uint8_t val)
{
	OCR2A=val;
}

/*!	\brief	Gets the current Contrast of the LCD
	\return	The Contrast
*/
static inline uint8_t	LCDGetContrast(void)
{
	return OCR2A;
}


bool LCDBuildVBarChar(uint8_t nBars);

#endif /* LCD_H_ */