﻿/*
 * adc.h
 *
 * Created: 13.11.2012 14:05:16
 *  Author: rolo
 */ 


#ifndef ADC_H_
#define ADC_H_

extern volatile uint8_t	adcFlags;
static const uint8_t	ADCFLAG_NEWRESULTS=1;	///< All Channels have been updated
static const uint8_t	ADCFLAG_NEWAVERAGES=2;	///< All Averages have been updated

/*!	\brief Holds raw ADC Values for all Channels
*/
typedef union
{
	struct
	{
		uint16_t	ADC_Chan0;
		uint16_t	ADC_Chan1;
		uint16_t	ADC_Chan2;
		uint16_t	ADC_Chan3;
		uint16_t	ADC_HSTemp;	///< Temperature of the Heatsink
		uint16_t	ADC_Temp;	///< Display Temperature
		uint16_t	ADC_P5;		///< 5V Supply
		uint16_t	ADC_P12;	///< 12V Supply
	} named;	///< Named Values per Channel
	uint16_t	array[8];	///< Array for access via Channel Number
} ADCData_t;


extern ADCData_t	ADCData;
extern ADCData_t	ADCDataAvg;
extern ADCData_t	ADCDataMin;
extern ADCData_t	ADCDataMax;
static ADCData_t	ADCDataMinTmp;
static ADCData_t	ADCDataMaxTmp;

void	InitADC(void);
void	ADCNextChannel(void);

/*!	\brief	Resets the Min/Max values of the Analog Values
*/
static inline void	ADCResetMinMax(void)
{
	for (int i=4;i>=0;i--)
	{
		ADCDataMin.array[i]=ADCDataMinTmp.array[i];
		ADCDataMax.array[i]=ADCDataMaxTmp.array[i];
		ADCDataMinTmp.array[i]=0xffff;
		ADCDataMaxTmp.array[i]=0;
	}
}

#endif /* ADC_H_ */