/*
 * Eload.h
 *
 * Created: 08.11.2013 11:59:33
 *  Author: rolo
 */ 


#ifndef ELOAD_H_
#define ELOAD_H_

#include <stdint.h>
#include <stddef.h>
#include <avr/pgmspace.h>

typedef	uint8_t	delay_t;

#define ADC_MIN_CHANNEL	4	///< First internal ADC-Channel used
#define ADC_MAX_CHANNEL	7	///< Last internal ADC-Channal used
#define ADCVoltsPerLSB (2.56/1024)	///< Voltage step for one LSB of the AD converter
#define dividerP5 (4.7/(4.7+22))	///< Resistor divider for P5. Gives 7.03V FSR or 6.86mV/LSB
#define dividerP12 (4.7/(4.7+68))	///< Resistor divider for Unreg. Gives 39.6V FSR or 38.7mV/LSB

extern uint8_t	mcusrMirror;
extern volatile uint8_t	tickCnt,secCnt,minCnt,hrCnt;

/*! \defgroup Timer_Flags Timer Flags

	Flags indicating an error. They are set when the error condition appears.
	The Status command displays and clears them.
	@{*/
extern volatile uint8_t	tFlags;
static const uint8_t TFLAG_SEC=1;	///< Is set once per Second
static const uint8_t TFLAG_MIN=2;	///< Is set once per Minute at Second 0
static const uint8_t TFLAG_HOUR=4;	///< Is set once per Hour at Minute 0
static const uint8_t TFLAG_DAY=8;	///< Is set every Day at Midnight
/*! @} */

extern volatile uint8_t	sFlags;
static const uint8_t SFLAG_REFRESH=1;	///< Is set three times per Second when Refresh-Items should be handled

extern volatile uint8_t	dFlags;
static const uint8_t DFLAG_ADC=1;		///< Gives information about voltage and current measurements
static const uint8_t DFLAG_SENSOR=2;	///< Gives information about sensors and on chip ADC
static const uint8_t DFLAG_AH=4;		///< Gives information about Ah and Wh calculations
static const uint8_t DFLAG_RCHAN=8;		///< Gives information about channel resistance computation
/*! @} */

/*! \defgroup Error_Flags Error Flags

	Flags indicating an error. They are set when the error condition appears.
	The Status command displays and clears them.
	@{*/
extern volatile uint8_t	eflags;
static const uint8_t	EFLAG_NTC1=1;	///< NTC1 (the onboard one) seems non-functional
static const uint8_t	EFLAG_NTC2=2;	///< NTC2 (the NTC on the Heat Sink) seems non-functional
static const uint8_t	EFLAG_P5=4;		///< +5V Supply out of tolerance
static const uint8_t	EFLAG_P12=8;	///< +12V Supply out of tolerance
static const uint8_t	EFLAG_SOA=16;	///< Indicates Limits caused by the SOA of the Transistor. Should be somehow displayed!
static const uint8_t	EFLAG_TEMP=32;	///< Heat Sink Overtemp
static const uint8_t	EFLAG_AVG_LOST=64;	///< New Averages were ready but the New Averages Flag was still set.
/*! @} */
extern PGM_P const eflag_descr[];	///< Array of strings containing a description for each flag

void	DoFlags();

extern void	Ticks2HMS(uint32_t ticks, char *str, size_t n);

#endif /* ELOAD_H_ */